/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.api;

import filenet.sim.api.IVWScenarioArrival;
import filenet.sim.api.VWScenarioArrivalOccurrence;
import filenet.sim.api.VWScenarioArrivalRecurrence;
import filenet.sim.api.VWScenarioDefinition;
import filenet.sim.api.VWScenarioTimeType;
import filenet.sim.api.VWScenarioValidationError;
import filenet.sim.api.VWScenarioWorkflowDefinition;
import filenet.sim.api.VWScenarioXMLHandler;
import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldType;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.base.VWString;
import filenet.vw.base.exprcomp.VWCompiledExpr;
import filenet.vw.base.exprcomp.VWCompiledRefExpr;
import filenet.vw.base.exprcomp.VWExpr;
import java.io.Serializable;
import java.util.Date;
import java.util.Vector;

public final class VWScenarioArrivalDefinition
implements IVWScenarioArrival,
Serializable,
Cloneable {
    protected static final int NUM_INDICES = 2;
    public static final int LVALUE = 0;
    public static final int RVALUE = 1;
    private VWScenarioWorkflowDefinition m_scenarioWFDef = null;
    private String m_name = null;
    private Object m_startTime = null;
    private VWScenarioArrivalOccurrence m_occurrence = null;
    private VWScenarioArrivalRecurrence m_recurrence = null;
    private String[][] m_fieldAssignments = null;

    protected VWScenarioArrivalDefinition(String name, Object startTime, VWScenarioArrivalOccurrence occurrence, VWScenarioArrivalRecurrence recurrence, String[][] fieldAssignments, VWScenarioWorkflowDefinition scenarioWFDef) throws VWException {
        this.m_scenarioWFDef = scenarioWFDef;
        this.setName(name);
        this.setStartTime(startTime);
        this.setOccurrence(occurrence);
        this.setRecurrence(recurrence);
        this.setFieldAssignments(fieldAssignments);
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String theName) throws VWException {
        if (theName == null) {
            throw new VWException("sim.api.VWScenarioArrivalDefinition.NullNameParameter", "The name parameter can not be null.");
        }
        if (theName.equals(this.m_name)) {
            return;
        }
        if (this.m_scenarioWFDef.hasArrival(theName)) {
            throw new VWException("sim.api.VWScenarioArrivalDefinition.ArrivalDefAlreadyExists", "An arrival with the name {0} has already been created.", theName);
        }
        this.m_scenarioWFDef.updateArrival(this.m_name, theName);
        this.m_name = theName;
    }

    public Object getStartTime() {
        return this.m_startTime;
    }

    public void setStartTime(Object startTime) throws VWException {
        if (!VWScenarioTimeType.isValid(startTime)) {
            throw new VWException("sim.api.VWScenarioArrivalDefinition.InvalidTimeValue", "The value is a {0}, which is not a supported time type.", startTime != null ? startTime.getClass().getName() : null);
        }
        this.m_startTime = startTime;
    }

    public VWScenarioArrivalOccurrence getOccurrence() {
        return this.m_occurrence;
    }

    public void setOccurrence(VWScenarioArrivalOccurrence occurrence) {
        this.m_occurrence = occurrence;
        if (this.m_occurrence != null) {
            this.m_occurrence.setArrivalDefinition(this);
        }
    }

    public VWScenarioArrivalRecurrence getRecurrence() {
        return this.m_recurrence;
    }

    public void setRecurrence(VWScenarioArrivalRecurrence reoccurrence) {
        this.m_recurrence = reoccurrence;
        if (this.m_recurrence != null) {
            this.m_recurrence.setArrivalDefinition(this);
        }
    }

    public String[][] getFieldAssignments() {
        return this.m_fieldAssignments;
    }

    public void setFieldAssignments(String[][] fieldAssignments) throws VWException {
        if (fieldAssignments != null) {
            for (int i = 0; i < fieldAssignments.length; ++i) {
                if (fieldAssignments[i].length != 2) {
                    throw new VWException("sim.api.VWArrivalDefinition.FieldAssignmentArrayWrongDimension", "Field assignment array has wrong dimension, row {0} has {1} elements, should have 2 (representing the field names and values)", String.valueOf(i), String.valueOf(fieldAssignments[i].length));
                }
                if (fieldAssignments[i][0] == null || fieldAssignments[i][1] == null) {
                    throw new VWException("sim.api.VWArrivalDefinition.NullElementInFieldAssignmentArray", "Field assignment array contains a null entry in row {0}", String.valueOf(i));
                }
                try {
                    this.m_scenarioWFDef.getWorkflowDefinition().getField(fieldAssignments[i][0]);
                    continue;
                }
                catch (VWException e) {
                    throw new VWException("sim.api.VWArrivalDefinition.InvalidFieldNameInFieldAssignmentArray", "The field name {0} in row {1} is not a valid field of the associated workflow definition.", fieldAssignments[i][0], String.valueOf(i));
                }
            }
        }
        this.m_fieldAssignments = fieldAssignments;
    }

    public void toXML(StringBuffer buffer) throws VWException {
        this.toXML(buffer, "", false);
    }

    protected void toXML(StringBuffer buffer, String baseIndent, boolean runtime) throws VWException {
        String LEVEL_1_INDENT = baseIndent + "\t";
        String LEVEL_2_INDENT = LEVEL_1_INDENT + "\t";
        String LEVEL_3_INDENT = LEVEL_2_INDENT + "\t";
        String LEVEL_4_INDENT = LEVEL_3_INDENT + "\t";
        buffer.append(baseIndent + "<Arrival Name=\"" + this.getName() + "\">\n");
        VWWorkflowDefinition workflowDef = this.m_scenarioWFDef.getWorkflowDefinition(runtime);
        String runtimeId = workflowDef.getRuntimeId() != null ? workflowDef.getRuntimeId().toString() : "";
        buffer.append(LEVEL_1_INDENT + "<Process ");
        buffer.append("Name=\"" + workflowDef.getName() + "\" ");
        buffer.append("Identifier=\"" + VWScenarioXMLHandler.toXMLString(runtimeId) + "\"/>\n");
        buffer.append(LEVEL_1_INDENT + "<StartTime>\n");
        VWScenarioTimeType.timeValueToXML(this.m_startTime, buffer, LEVEL_2_INDENT);
        buffer.append(LEVEL_1_INDENT + "</StartTime>\n");
        if (this.m_occurrence != null) {
            this.m_occurrence.toXML(buffer, LEVEL_1_INDENT);
        }
        if (this.m_recurrence != null) {
            this.m_recurrence.toXML(buffer, LEVEL_1_INDENT);
        }
        if (this.m_fieldAssignments != null) {
            buffer.append(LEVEL_1_INDENT + "<FieldValues>\n");
            for (int k = 0; k < this.m_fieldAssignments.length; ++k) {
                buffer.append(LEVEL_2_INDENT + "<FieldValue ");
                buffer.append("Name=\"" + VWScenarioXMLHandler.toXMLString(this.m_fieldAssignments[k][0]) + "\" ");
                buffer.append("Value=\"" + VWScenarioXMLHandler.toXMLString(this.m_fieldAssignments[k][1]) + "\"/>\n");
            }
            buffer.append(LEVEL_1_INDENT + "</FieldValues>\n");
        }
        buffer.append(baseIndent + "</Arrival>\n");
    }

    public String toString() {
        return this.getName();
    }

    public void validate(Vector EDefVector) throws VWException {
        String[][] a;
        VWScenarioDefinition scenario = this.m_scenarioWFDef.getScenario();
        Date absScenarioStartTime = scenario.getAbsoluteStartTime();
        Date absScenarioEndTime = scenario.getAbsoluteEndTime();
        VWScenarioTimeType.validate(this.getStartTime(), absScenarioStartTime, 7, this.getName(), this.getScenarioWorkflow().getWorkflowDefinition().getName(), null, null, null, null, EDefVector);
        Date absStartTime = VWScenarioTimeType.getAbsoluteTime(this.getStartTime());
        if (absStartTime != null) {
            boolean outOfRange = false;
            if (absScenarioStartTime != null && absStartTime.compareTo(absScenarioStartTime) < 0) {
                outOfRange = true;
            }
            if (absScenarioEndTime != null && absStartTime.compareTo(absScenarioEndTime) >= 0) {
                outOfRange = true;
            }
            if (outOfRange) {
                VWString theMessage = new VWString("vw.api.VWScenarioArrivalDefinition.StartTimeOutOfRange", "Start date is out of range, arrival start date should fall between the simulation start and end date.", this.getName());
                VWScenarioValidationError theError = new VWScenarioValidationError(7, 1, this.getName(), null, theMessage.toString(), this.getScenarioWorkflow().getWorkflowDefinition().getName());
                EDefVector.addElement(theError);
            }
        }
        if (this.m_occurrence != null) {
            this.m_occurrence.validate(EDefVector);
        }
        if (this.m_recurrence != null) {
            this.m_recurrence.validate(EDefVector);
        }
        if ((a = this.getFieldAssignments()) != null) {
            for (int i = 0; i < a.length; ++i) {
                VWCompiledRefExpr lCompRes = new VWCompiledRefExpr();
                String[] theErrorStrings = VWExpr.compileVWExpr(":=" + a[i][0], this.m_scenarioWFDef.getFieldCollection(), this.m_scenarioWFDef.getInheritedFieldCollection(), null, null, true, lCompRes);
                if (theErrorStrings != null) {
                    int errorCount = theErrorStrings.length;
                    for (int k = 0; k < errorCount; ++k) {
                        VWString theMessage = new VWString("vw.api.VWScenarioArrivalDefinition.FieldAssignmentBadLValue", "Field Assignment[{0}], the Left side of assignment, {1}, is not a valid LValue, Syntax Error {2}", String.valueOf(i), a[i][0], theErrorStrings[k]);
                        VWScenarioValidationError theError = new VWScenarioValidationError(7, 1, this.getName(), a[i][0], theMessage.toString(), this.getScenarioWorkflow().getWorkflowDefinition().getName());
                        EDefVector.addElement(theError);
                    }
                    continue;
                }
                int expectedRValueType = lCompRes.getResultType();
                boolean expectedRValueIsArray = lCompRes.getResultIsArray();
                VWCompiledExpr rCompRes = new VWCompiledExpr();
                theErrorStrings = VWExpr.compileVWExpr(a[i][1], this.m_scenarioWFDef.getFieldCollection(), this.m_scenarioWFDef.getInheritedFieldCollection(), null, null, true, rCompRes);
                if (theErrorStrings != null) {
                    int errorCount = theErrorStrings.length;
                    for (int j = 0; j < errorCount; ++j) {
                        VWString theMessage = new VWString("vw.api.VWScenarioArrivalDefinition.FieldAssignmentRValSyntaxError", "Field Assignment[{0}], RValue (expected type is {1}), syntax error: {2}", String.valueOf(i), VWFieldType.getLocalizedString(expectedRValueType) + (expectedRValueIsArray ? " array " : ""), theErrorStrings[j]);
                        VWScenarioValidationError theError = new VWScenarioValidationError(7, 1, this.getName(), a[i][0], theMessage.toString(), this.getScenarioWorkflow().getWorkflowDefinition().getName());
                        EDefVector.addElement(theError);
                    }
                    continue;
                }
                if (VWScenarioDefinition.isCompatibleType(lCompRes.getResultType(), rCompRes.getResultType()) && lCompRes.getResultIsArray() == rCompRes.getResultIsArray()) continue;
                VWString theMessage = new VWString("VWScenarioArrivalDefinition.FieldAssignmentTypeMismatch", "Field Assignment[{0}],  Incompatible type, expected {1}, found {2}.", String.valueOf(i), VWFieldType.getLocalizedString(lCompRes.getResultType()) + (lCompRes.getResultIsArray() ? "[ ]" : ""), VWFieldType.getLocalizedString(rCompRes.getResultType()) + (rCompRes.getResultIsArray() ? "[ ]" : ""));
                VWScenarioValidationError theError = new VWScenarioValidationError(7, 1, this.getName(), a[i][0], theMessage.toString(), this.getScenarioWorkflow().getWorkflowDefinition().getName());
                EDefVector.addElement(theError);
            }
        }
    }

    protected Object clone(String arrivalName) {
        VWScenarioArrivalDefinition clone = null;
        try {
            clone = (VWScenarioArrivalDefinition)super.clone();
            clone.m_name = arrivalName;
            clone.m_startTime = VWScenarioTimeType.clone(this.m_startTime);
            if (this.m_occurrence != null) {
                clone.m_occurrence = (VWScenarioArrivalOccurrence)this.m_occurrence.clone();
            }
            if (this.m_recurrence != null) {
                clone.m_recurrence = (VWScenarioArrivalRecurrence)this.m_recurrence.clone();
            }
            if (this.m_fieldAssignments != null) {
                clone.m_fieldAssignments = new String[this.m_fieldAssignments.length][2];
                for (int i = 0; i < this.m_fieldAssignments.length; ++i) {
                    String[] valueArray = new String[]{new String(this.m_fieldAssignments[i][0]), new String(this.m_fieldAssignments[i][1])};
                    clone.m_fieldAssignments[i] = valueArray;
                }
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }

    protected VWScenarioWorkflowDefinition getScenarioWorkflow() {
        return this.m_scenarioWFDef;
    }
}

